<?php


include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");
$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (
        isset($_GET['month']) && isset($_GET['year']) && isset($_GET['language']) &&
        isset($_GET['lv']) && isset($_GET['pageNo']) && isset($_GET['pageSize']) &&
        isset($_GET['userId'])
    ) {
        $month = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['month']));
        $year = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['year']));
        $language = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['language']));
        $lv = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['lv']));
        $pageNo = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['pageNo']));
        $pageSize = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['pageSize']));
        $userId = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['userId']));

        $firstDay = date("Y-m-d", strtotime("$year-$month-01"));
        $lastDay = date("Y-m-t", strtotime("$year-$month-01"));

        // Get user's owncode
        $owncode = '';
        $stmt = $conn->prepare("SELECT owncode FROM shonu_subjects WHERE id = ?");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $owncode = $row['owncode'];
        }
        $stmt->close();

        // Get referred users based on level
        $referredIds = [];
        if ($lv == -1) {
            $stmt = $conn->prepare("SELECT id FROM shonu_subjects WHERE code = ? OR code1 = ? OR code2 = ? OR code3 = ? OR code4 = ? OR code5 = ?");
            $stmt->bind_param("ssssss", $owncode, $owncode, $owncode, $owncode, $owncode, $owncode);
        } else {
            $codeField = $lv == 1 ? 'code' : 'code' . ($lv - 1);
            $query = "SELECT id FROM shonu_subjects WHERE $codeField = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("s", $owncode);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $referredIds[] = $row['id'];
        }
        $stmt->close();

        if (empty($referredIds)) {
            $res['data'] = [
                'monthlyData' => [],
                'pageNo' => (int)$pageNo,
                'totalCount' => 0,
                'totalPage' => 0
            ];
            $res['code'] = 0;
            $res['msg'] = 'Succeed';
            $res['msgCode'] = 0;
            http_response_code(200);
            echo json_encode($res);
            exit;
        }

        // Prepare IN clause for referred IDs
        $inClause = implode(',', array_fill(0, count($referredIds), '?'));
        $types = str_repeat('i', count($referredIds));

        // Helper for binding params dynamically
        function refValues($arr) {
            if (strnatcmp(phpversion(), '5.3') >= 0) {
                $refs = [];
                foreach ($arr as $key => $value) {
                    $refs[$key] = &$arr[$key];
                }
                return $refs;
            }
            return $arr;
        }

        // Fetch all vyavahara (betting) data for the month for all referred users
        $rbxquery = "SELECT koduvavanu, DATE(tiarikala) as day, SUM(ayoga) as sumayoga, COUNT(DISTINCT koduvavanu) as bcs, SUM(ketebida) as bas
            FROM vyavahara
            WHERE DATE(tiarikala) BETWEEN ? AND ? AND koduvavanu IN ($inClause)
            GROUP BY koduvavanu, day";
        $stmt = $conn->prepare($rbxquery);
        $params = array_merge([$firstDay, $lastDay], $referredIds);
        $bind_names = [];
        $bind_names[] = str_repeat('s', 2) . $types;
        foreach ($params as $k => $v) {
            $bind_names[] = &$params[$k];
        }
        call_user_func_array([$stmt, 'bind_param'], $bind_names);
        $stmt->execute();
        $rbxresult = $stmt->get_result();
        $bettingData = [];
        while ($row = $rbxresult->fetch_assoc()) {
            $bettingData[$row['koduvavanu']][$row['day']] = $row;
        }
        $stmt->close();

        // Fetch all recharge data for the month for all referred users
        $rchquery = "SELECT balakedara, DATE(dinankavannuracisi) as day, COUNT(*) as count, SUM(motta) as sum
            FROM thevani
            WHERE sthiti = '1' AND DATE(dinankavannuracisi) BETWEEN ? AND ? AND balakedara IN ($inClause)
            GROUP BY balakedara, day";
        $stmt = $conn->prepare($rchquery);
        $params = array_merge([$firstDay, $lastDay], $referredIds);
        $bind_names = [];
        $bind_names[] = str_repeat('s', 2) . $types;
        foreach ($params as $k => $v) {
            $bind_names[] = &$params[$k];
        }
        call_user_func_array([$stmt, 'bind_param'], $bind_names);
        $stmt->execute();
        $rchresult = $stmt->get_result();
        $rechargeData = [];
        while ($row = $rchresult->fetch_assoc()) {
            $rechargeData[$row['balakedara']][$row['day']] = $row;
        }
        $stmt->close();

        // Fetch all withdrawal data for the month for all referred users
        $withdrawalQuery = "SELECT balakedara, DATE(dinankavannuracisi) as day, SUM(motta) as withdrawalSum
            FROM hintegedukolli
            WHERE sthiti = '1' AND DATE(dinankavannuracisi) BETWEEN ? AND ? AND balakedara IN ($inClause)
            GROUP BY balakedara, day";
        $stmt = $conn->prepare($withdrawalQuery);
        $params = array_merge([$firstDay, $lastDay], $referredIds);
        $bind_names = [];
        $bind_names[] = str_repeat('s', 2) . $types;
        foreach ($params as $k => $v) {
            $bind_names[] = &$params[$k];
        }
        call_user_func_array([$stmt, 'bind_param'], $bind_names);
        $stmt->execute();
        $withdrawalResult = $stmt->get_result();
        $withdrawalData = [];
        while ($row = $withdrawalResult->fetch_assoc()) {
            $withdrawalData[$row['balakedara']][$row['day']] = $row;
        }
        $stmt->close();

        // Fetch user details for all referred users
        $userDetailsQuery = "SELECT id, codechorkamukala, status, code, code1, code2, code3, code4, code5 FROM shonu_subjects WHERE id IN ($inClause)";
        $stmt = $conn->prepare($userDetailsQuery);
        $bind_names = [];
        $bind_names[] = $types;
        foreach ($referredIds as $k => $v) {
            $bind_names[] = &$referredIds[$k];
        }
        call_user_func_array([$stmt, 'bind_param'], $bind_names);
        $stmt->execute();
        $userDetailsResult = $stmt->get_result();
        $userDetailsArr = [];
        while ($row = $userDetailsResult->fetch_assoc()) {
            $userDetailsArr[$row['id']] = $row;
        }
        $stmt->close();

        // Fetch first recharge for each referred user in the month
        $firstRechargeQuery = "SELECT balakedara, MIN(DATE(dinankavannuracisi)) as first_date, SUM(motta) as first_sum
            FROM thevani
            WHERE sthiti = '1' AND DATE(dinankavannuracisi) BETWEEN ? AND ? AND balakedara IN ($inClause)
            GROUP BY balakedara";
        $stmt = $conn->prepare($firstRechargeQuery);
        $params = array_merge([$firstDay, $lastDay], $referredIds);
        $bind_names = [];
        $bind_names[] = str_repeat('s', 2) . $types;
        foreach ($params as $k => $v) {
            $bind_names[] = &$params[$k];
        }
        call_user_func_array([$stmt, 'bind_param'], $bind_names);
        $stmt->execute();
        $firstRechargeResult = $stmt->get_result();
        $firstRechargeData = [];
        while ($row = $firstRechargeResult->fetch_assoc()) {
            $firstRechargeData[$row['balakedara']] = [
                'date' => $row['first_date'],
                'sum' => $row['first_sum']
            ];
        }
        $stmt->close();

        // Loop through each day of the month
        $monthlyData = [];
        $currentDay = $firstDay;
        while (strtotime($currentDay) <= strtotime($lastDay)) {
            $dailyData = [
                'date' => $currentDay,
                'list' => [],
                'data' => [
                    'rebateAmountSum' => 0,
                    'betCountSum' => 0,
                    'betAmountSum' => 0,
                    'recahrgeCount' => 0,
                    'recahrgeAmountSum' => 0,
                    'firstRecahrgeCount' => 0,
                    'firstRecahrgeAmountSum' => 0,
                    'withdrawalAmountSum' => 0,
                    'level1BettersCount' => 0
                ]
            ];
            $level1BettersCount = 0;

            foreach ($referredIds as $referredId) {
                $bet = $bettingData[$referredId][$currentDay] ?? ['sumayoga'=>0,'bcs'=>0,'bas'=>0];
                $rch = $rechargeData[$referredId][$currentDay] ?? ['count'=>0,'sum'=>0];
                $wd = $withdrawalData[$referredId][$currentDay] ?? ['withdrawalSum'=>0];

                // First recharge logic
                $firstRecharge = $firstRechargeData[$referredId] ?? null;
                if ($firstRecharge && $firstRecharge['date'] == $currentDay) {
                    $dailyData['data']['firstRecahrgeCount'] += 1;
                    $dailyData['data']['firstRecahrgeAmountSum'] += (float)$firstRecharge['sum'];
                }

                // Only add to list if there's activity
                if ($bet['bas'] > 0 || $rch['sum'] > 0 || $wd['withdrawalSum'] > 0 || ($firstRecharge && $firstRecharge['date'] == $currentDay)) {
                    $user = $userDetailsArr[$referredId];
                    // Calculate level
                    $level = 0;
                    if ($user['code'] == $owncode) $level = 1;
                    elseif ($user['code1'] == $owncode) $level = 2;
                    elseif ($user['code2'] == $owncode) $level = 3;
                    elseif ($user['code3'] == $owncode) $level = 4;
                    elseif ($user['code4'] == $owncode) $level = 5;
                    elseif ($user['code5'] == $owncode) $level = 6;

                    if ($level == 1 && $bet['bcs'] > 0) $level1BettersCount++;

                    $dailyData['list'][] = [
                        'userID' => (int)$referredId,
                        'lv' => (int)$level,
                        'nickName' => $user['codechorkamukala'],
                        'userState' => (int)$user['status'],
                        'searchTime' => $currentDay,
                        'lotteryAmount' => (float)$bet['bas'],
                        'rechargeAmount' => (float)$rch['sum'],
                        'rebateAmount' => (float)$bet['sumayoga'],
                        'withdrawalAmount' => (float)$wd['withdrawalSum'],
                        'firstRecharge' => ($firstRecharge && $firstRecharge['date'] == $currentDay) ? (float)$firstRecharge['sum'] : 0
                    ];

                    // Update daily totals
                    $dailyData['data']['rebateAmountSum'] += (float)$bet['sumayoga'];
                    $dailyData['data']['betCountSum'] += (int)$bet['bcs'];
                    $dailyData['data']['betAmountSum'] += (float)$bet['bas'];
                    $dailyData['data']['recahrgeCount'] += (int)$rch['count'];
                    $dailyData['data']['recahrgeAmountSum'] += (float)$rch['sum'];
                    $dailyData['data']['withdrawalAmountSum'] += (float)$wd['withdrawalSum'];
                }
            }
            $dailyData['data']['level1BettersCount'] = $level1BettersCount;
            $profitLoss = $dailyData['data']['recahrgeAmountSum'] - $dailyData['data']['withdrawalAmountSum'];
            $dailyData['data']['profit'] = $profitLoss > 0 ? $profitLoss : 0;
            $dailyData['data']['loss'] = $profitLoss < 0 ? abs($profitLoss) : 0;
            $dailyData['data']['totalRefers'] = count($dailyData['list']);

            if (count($dailyData['list']) > 0) {
                $monthlyData[] = $dailyData;
            }
            $currentDay = date("Y-m-d", strtotime($currentDay . " +1 day"));
        }

        // Pagination for monthly data
        $totalCount = count($monthlyData);
        $startIndex = ($pageNo - 1) * $pageSize;
        $monthlyData = array_slice($monthlyData, $startIndex, $pageSize);

        $response = [
            'monthlyData' => $monthlyData,
            'pageNo' => (int)$pageNo,
            'totalCount' => $totalCount,
            'totalPage' => ceil($totalCount / $pageSize)
        ];

        $res['data'] = $response;
        $res['code'] = 0;
        $res['msg'] = 'Succeed';
        $res['msgCode'] = 0;
        http_response_code(200);
        echo json_encode($res);

    } else {
        $res['code'] = 7;
        $res['msg'] = 'Param is Invalid';
        $res['msgCode'] = 6;
        http_response_code(200);
        echo json_encode($res);
    }
} else {
    http_response_code(405);
    echo json_encode($res);
}
?>